<?php
function mytheme_add_admin_page(){
    add_menu_page('Theme Settings','Theme Settings','manage_options','mytheme-settings','mytheme_settings_page','dashicons-admin-customizer',61);
}
add_action('admin_menu', 'mytheme_add_admin_page');

function mytheme_settings_page() {
    ?>
    <div class="wrap">
        <h1>Theme Configuration</h1>
        <form method="post" action="options.php">
            <?php settings_fields('mytheme-settings-group'); ?>
            <?php do_settings_sections('mytheme-settings-group'); ?>
            <table class="form-table">
                <tr><th>Background Color</th>
                    <td><input type="text" name="bg_color" value="<?php echo esc_attr(get_option('bg_color')); ?>" placeholder="#ffffff" /></td>
                </tr>
                <tr><th>Font Size (px)</th>
                    <td><input type="number" name="font_size" value="<?php echo esc_attr(get_option('font_size')); ?>" /></td>
                </tr>
            </table>
            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}
function mytheme_register_settings(){
    register_setting('mytheme-settings-group', 'bg_color');
    register_setting('mytheme-settings-group', 'font_size');
}
add_action('admin_init', 'mytheme_register_settings');

function mytheme_dynamic_css() {
    $bg = get_option('bg_color', '#ffffff');
    $font = get_option('font_size', '16');
    echo "<style>body { background-color: {$bg}; font-size: {$font}px; }</style>";
}
add_action('wp_head', 'mytheme_dynamic_css');
?>